/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.dialog;

import com.aptana.editor.php.internal.search.IElementNode;
import com.aptana.editor.php.internal.search.ITypeNode;
import com.aptana.editor.php.internal.search.PHPSearchEngine;
import com.aptana.editor.php.internal.ui.dialog.CustomFilteredItemsSelectionDialog;
import com.aptana.editor.php.internal.ui.dialog.Messages;
import com.aptana.editor.php.internal.ui.dialog.TypeSelectionDialog;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementSelectionDialog
extends TypeSelectionDialog {
    private static final String CONSTANTS = "constants";
    private static final String FUNCTIONS = "functions";
    private static final String CLASSES = "classes";
    private static final String TRAITS = "traits";
    private boolean addTraits;
    private boolean addClasses;
    private boolean addFunctions;
    private boolean addConstants;

    protected void storeDialog(IDialogSettings settings) {
        settings.put(TRAITS, this.addTraits);
        settings.put(CLASSES, this.addClasses);
        settings.put(FUNCTIONS, this.addFunctions);
        settings.put(CONSTANTS, this.addConstants);
        super.storeDialog(settings);
    }

    @Override
    protected void fillContentProvider(CustomFilteredItemsSelectionDialog.AbstractContentProvider contentProvider, CustomFilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        Collection<IElementNode> allKnownTypes;
        if (this.addClasses || this.addTraits) {
            allKnownTypes = PHPSearchEngine.getInstance().getAllKnownTypes();
            for (ITypeNode iTypeNode : allKnownTypes) {
                if ((!this.addTraits || iTypeNode.getKind() != 4) && (!this.addClasses || iTypeNode.getKind() != 1)) continue;
                contentProvider.add((Object)iTypeNode, itemsFilter);
            }
        }
        if (this.addFunctions) {
            allKnownTypes = PHPSearchEngine.getInstance().getAllKnownFunctions();
            for (IElementNode iElementNode : allKnownTypes) {
                contentProvider.add((Object)iElementNode, itemsFilter);
            }
        }
        if (this.addConstants) {
            allKnownTypes = PHPSearchEngine.getInstance().getAllKnownConstants();
            for (IElementNode iElementNode : allKnownTypes) {
                contentProvider.add((Object)iElementNode, itemsFilter);
            }
        }
    }

    public ElementSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
    }

    protected void createExtras(Composite content) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        String string = dialogSettings.get(TRAITS);
        this.addTraits = string != null ? Boolean.parseBoolean(string) : true;
        string = dialogSettings.get(CLASSES);
        this.addClasses = string != null ? Boolean.parseBoolean(string) : true;
        string = dialogSettings.get(FUNCTIONS);
        this.addFunctions = string != null ? Boolean.parseBoolean(string) : true;
        string = dialogSettings.get(CONSTANTS);
        this.addConstants = string != null ? Boolean.parseBoolean(string) : true;
        Group extraBar = new Group(content, 0);
        extraBar.setLayout((Layout)new GridLayout(4, false));
        final Button traits = new Button((Composite)extraBar, 32);
        final Button classes = new Button((Composite)extraBar, 32);
        final Button functions = new Button((Composite)extraBar, 32);
        final Button constants = new Button((Composite)extraBar, 32);
        extraBar.setText(Messages.ElementSelectionDialog_extraBarText);
        traits.setText(Messages.ElementSelectionDialog_traits);
        traits.setSelection(this.addTraits);
        classes.setText(Messages.ElementSelectionDialog_classes);
        classes.setSelection(this.addClasses);
        functions.setText(Messages.ElementSelectionDialog_functions);
        functions.setSelection(this.addFunctions);
        constants.setText(Messages.ElementSelectionDialog_constants);
        constants.setSelection(this.addConstants);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ElementSelectionDialog.this.addTraits = traits.getSelection();
                ElementSelectionDialog.this.addClasses = classes.getSelection();
                ElementSelectionDialog.this.addFunctions = functions.getSelection();
                ElementSelectionDialog.this.addConstants = constants.getSelection();
                ElementSelectionDialog.this.refreshContent();
            }
        };
        traits.addSelectionListener(selectionListener);
        classes.addSelectionListener(selectionListener);
        functions.addSelectionListener(selectionListener);
        constants.addSelectionListener(selectionListener);
        extraBar.setLayoutData((Object)new GridData(768));
        super.createExtras(content);
    }
}

